%%%% Analysis for Android Haptics HW assessment
%%%% Input type :  Effect1 & Effect 2
%%%% Version : 1.0 
%%%% Purpose : Release
%%%% Date: 05/18/2020 

clear
clc
close all

%%%%%%%%%%%%%%%%
%%%%% USER INPUTS %%%%%%
%%%%%%%%% Your input .wav function should be located at the same folder as this function. 

%%%%Calibration value for the 3 Axis Accelerometer -  %%%%%%
Cal=0.5/1.414; % Calibration value for 3 axis accelerometer --> Digital value per Gpeak 
%%%%% In this setting 0.5 value in Audacity corresponds to 1.414 Gpeak
%%%%% Value Depends on Amplifier settings, accelerometer type.(Current "Cal" Value given for
%%%%% Endevco 35c-10 with 100X gain setting in the CCLD signal conditioner) 
%%%% Suggest to use a calibrator to calculate the exact calibration factor
%%%% for each accelerometer and CCLD amplifier condition. 


prompt = {'Enter name of the file'};
dlgtitle = 'File name';
dims = [1 35];
definput = {'effect_1.wav'};
answer = inputdlg(prompt,dlgtitle,dims,definput);


[y,Fs]=audioread(answer{1}); %% .wav file as the input function 

%%%%%%HARD INPUTS (Suggest - DO NOT CHANGE) %%%%%%%%
Low_end_threshold = 0.01; % Set low end thredshold as 1% --> DO NOT CHANGE
High_end_threshold = 0.1; % Set high end thredshold as 10% --> DO NOT CHANGE
Stop_end_threshold = 0.001; % Set stop end thredshold as 1% --> DO NOT CHANGE


%%%%Low Pass Filter to Eliminate High Frequency Effects - Do NOT CHANGE%%%%%%
LPF.ord = 2;  % Order of Filters (Higher = stronger filtering)
LPF.sR = 48000; % Sample Rate of Filter 

LPF.type = 'low' ; % Filter Type: Low Pass Filter 
LPF.lpfcut = 5000;   % Low Pass Cutoff Freq. in Hz.

% Design Low  Pass Filter
[b,a]=butter(LPF.ord,LPF.lpfcut/(LPF.sR/2),LPF.type);


%%%%% Code %%%%%%%
Per=(1/Fs);
t=Per:Per:size(y,1)*Per;
y=y./Cal;
X=filtfilt(b,a,y(:,1));

figure(1)
plot(t,X,'b')
title('Set time_gap_start and time_gap_end variables based on this plot','Interpreter', 'none','Fontsize',16)
xlabel('time(s)')
ylabel('amplitude(gee)')
grid on

prompt = {'Enter start time of signal (sec):','Enter end time of signal(sec):'};
dlgtitle = 'Input parameters';
dims = [1 35];
definput = {'0','2'};
answer = inputdlg(prompt,dlgtitle,dims,definput);

time_gap_start=str2num(answer{1}); %Set start time of the actual signal based on figure(1)
time_gap_end=str2num(answer{2}); % Set stop time of the actual signal based on figure(1)


startf = round(time_gap_start*Fs);
if startf==0 
    startf=1 ;
end
endf = round(time_gap_end*Fs);

t1= t(startf:endf)-t(startf);
X1= X(startf:endf);

absX1=(abs(X1));
X1_mx=find(absX1==max(absX1));

min_time=find(abs(X1)<Low_end_threshold*max(abs(X1)));
min_time=find(min_time<X1_mx);
X1_low=min_time(end):X1_mx;


t1=t1(X1_low(1):end)-t1(X1_low(1));
X1=X1(X1_low(1):end);


absX1=(abs(X1));
X1_mx=find(absX1==max(absX1));


if X1(X1_mx)<0
TF=islocalmin(X1);
TF2=find(TF==1 & X1 < 0);
else
TF=islocalmax(X1);
TF2=find(TF==1 & X1 > 0);
end

for i=1:size(TF2,1)
    k=i;
    if abs(X1(TF2(i)))<abs(X1(X1_mx))*Stop_end_threshold
        if TF2(i)>X1_mx
        R_stop=TF2(i);
        break
        end
    end
end

t1=t1(1:R_stop);
X1=X1(1:R_stop);


TFm=islocalmin(X1);
TFp=islocalmax(X1);



if X1(X1_mx)<0
TF2=find(TFm==1 & X1 < 0);
TF2e=find(TFp==1 & X1 > 0);

else
TF2=find(TFp==1 & X1 > 0);
TF2e=find(TFm==1 & X1 < 0);

end

TF = sort([TF2;TF2e]);

for i=1:length(TF)
    if abs(X1(TF(i)))< abs(X1(X1_mx))*High_end_threshold
        if TF(i)>X1_mx
        X1_high2(i)=TF(i);
        end
    end
end

X1_high2=nonzeros(X1_high2);


figure(2)
plot(t1(1:X1_high2(1)-1),X1(1:X1_high2(1)-1),'ro',t1(X1_high2(1):R_stop),X1(X1_high2(1):R_stop),'b*')
legend('PEAK','TAIL')
ylabel('Acceleration (gee)');xlabel('time(s)')
title('Effect 1 or 2 Acceleration Profile')
grid on


Peak_Duration=t1(X1_high2(1))*1000 %in ms
Peak_Amplitude=abs(X1(X1_mx))

PRR=20*log10(rms(X1(1:X1_high2(1)))/rms(X1((X1_high2(1)+1):R_stop)))

return

